// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2004 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Md5 calculation and options procedures for Tsc.
//................................................
#include <windows.h>  
#include "Tsc.h"
#include "Prototypes.h"
#include "ContextHelp.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD		dwStringSafeFlag;
extern	HWND		hMainWindow;
extern	LPCTSTR		lpIconPointer;
extern	LPCTSTR		lpszAppName;
extern	LPTSTR		lpszNA;
extern	HINSTANCE	hInst;
extern	BOOL		bUpdateRegistry;
extern	BOOL		bProcessInProgress;
extern	MD5_CTX		Md5Context;
extern	BYTE		TestEncrypt;
extern	LPCSTR		lpContextCalc;
extern	DWORD		dwN_Bytes;
extern	BYTE		Modulus_N[MAX_MOD_SLOP*2];
extern	BYTE		E_Temp[MAX_MOD_SLOP];
extern	BYTE		Temp1[MAX_MOD_SLOP*2];
extern	BYTE		Temp2[MAX_MOD_SLOP*2];
extern	DWORD		dwCountBytes;
extern	BYTE		DefaultToolbar[];
extern	DWORD		dwMyErrorCode;
extern	DWORD		bUseNew;
extern	SHACONTEXT	ShaContext;
extern	HMENU		hMenu;
extern	LPBYTE		lpA1;
extern	LPBYTE		lpPW;
extern	BOOL		bExitTheProgram;
extern	TCHAR		szDestination[MAX_PATH];
extern	LPCTSTR		lpszNullString;
extern	BOOL		bAa;
extern	BOOL		bRestrictionsInEffect;
extern	TCHAR		szPreviousDestinationDir[MAX_PATH];
extern	HFONT		hDlgFont;
extern	CONFIG		cfg;
extern	BOOL		bRemoveableMedia;
extern	DWORD		dwRemoveableInstalled;
extern	BOOL		bFirstTimeRead;
extern	DWORD		dwMajor;
extern	DWORD		dwMinor;
extern	HWND		hWndTT;

#define	Md5BufferSize	(128 * 1024)

// Local macros and definitions for the Md5 calculations.
//.......................................................
#define	F1(Xop,Yop,Zop) __asm	\
{								\
	__asm	mov		esi,Zop		\
	__asm	xor		esi,Yop		\
	__asm	and		esi,Xop		\
	__asm	xor		esi,Zop		\
}

#define F2(Xop,Yop,Zop) __asm	\
{								\
	__asm	mov		esi,Yop		\
	__asm	xor		esi,Xop		\
	__asm	and		esi,Zop		\
	__asm	xor		esi,Yop		\
}

#define F3(Xop,Yop,Zop) __asm	\
{								\
	__asm	mov		esi,Zop		\
	__asm	xor		esi,Yop		\
	__asm	xor		esi,Xop		\
}

#define F4(Xop,Yop,Zop) __asm	\
{								\
	__asm	mov		esi,Zop		\
	__asm	not		esi			\
	__asm	or		esi,Xop		\
	__asm	xor		esi,Yop		\
}

#define	Md5Step1(Wop,Xop,Yop,Zop,DataOp,ConstOp,Sop) __asm	\
{								\
	__asm	mov		esi,Zop		\
	__asm	xor		esi,Yop		\
	__asm	and		esi,Xop		\
	__asm	xor		esi,Zop		\
	__asm	add		esi,dword ptr [edi]##DataOp	\
	__asm	add		esi,ConstOp	\
	__asm	add		Wop,esi		\
	__asm	rol		Wop,Sop		\
	__asm	add		Wop,Xop		\
}

#define	Md5Step2(Wop,Xop,Yop,Zop,DataOp,ConstOp,Sop) __asm	\
{								\
	__asm	mov		esi,Yop		\
	__asm	xor		esi,Xop		\
	__asm	and		esi,Zop		\
	__asm	xor		esi,Yop		\
	__asm	add		esi,dword ptr [edi]##DataOp	\
	__asm	add		esi,ConstOp	\
	__asm	add		Wop,esi		\
	__asm	rol		Wop,Sop		\
	__asm	add		Wop,Xop		\
}

#define	Md5Step3(Wop,Xop,Yop,Zop,DataOp,ConstOp,Sop) __asm	\
{								\
	__asm	mov		esi,Zop		\
	__asm	xor		esi,Yop		\
	__asm	xor		esi,Xop		\
	__asm	add		esi,dword ptr [edi]##DataOp	\
	__asm	add		esi,ConstOp	\
	__asm	add		Wop,esi		\
	__asm	rol		Wop,Sop		\
	__asm	add		Wop,Xop		\
}

#define	Md5Step4(Wop,Xop,Yop,Zop,DataOp,ConstOp,Sop) __asm	\
{								\
	__asm	mov		esi,Zop		\
	__asm	not		esi			\
	__asm	or		esi,Xop		\
	__asm	xor		esi,Yop		\
	__asm	add		esi,dword ptr [edi]##DataOp	\
	__asm	add		esi,ConstOp	\
	__asm	add		Wop,esi		\
	__asm	rol		Wop,Sop		\
	__asm	add		Wop,Xop		\
}

// Exe program Md5 check structure. Used to check the exe file
// for tampering, or alteration.
//............................................................
MD5_CHECK		ProgramCheck = {0x05060708, 0x05060708,
								0x05060708, 0x05060708,
								0x05060708, 0x05060708,
								0x05060708, 0x05060708,
								0x05060708, 0x05060708};

// The memory image for modulus n.
//................................
BYTE			MemoryModN[] = {0x69, 0x3a, 0x3f, 0xf8, 0x21, 0xb5, 0x4c,
								0xb3, 0x74, 0x47, 0x50, 0xff, 0x09, 0x74,
								0xe6, 0xd1, 0x02, 0x19, 0xe2, 0x54, 0xf0,
								0x20, 0x65, 0x9e, 0x59, 0xaa, 0x1a, 0xf1,
								0x7f, 0x11, 0x1e, 0x08, 0x93, 0x6d, 0x95,
								0x5b, 0xaa, 0x4f, 0x37, 0xaf, 0xc4, 0xa5,
								0xa6, 0x20, 0x9e, 0x56, 0x14, 0x9c, 0xda,
								0x05, 0xeb, 0xbb, 0xc1, 0xaf, 0x7c, 0x3d,
								0xa5, 0x0a, 0xb8, 0xc8, 0x35, 0xf7, 0xe9,
								0x12, 0x7c, 0xe4, 0x5b, 0x2e, 0xf9, 0x9a,
								0xf2, 0x75, 0x7e, 0xfc, 0x63, 0x5a, 0xd5,
								0x9a, 0xdc, 0x37, 0xc3, 0x9a, 0xcd, 0x5e,
								0xa8, 0xe9, 0xa9, 0xe2, 0xe8, 0x03, 0x05,
								0x99, 0x92, 0x6b, 0x03, 0xde, 0x9d, 0x35,
								0x13, 0x12, 0x2a, 0x87, 0x0e, 0xe0, 0x99,
								0x46, 0xfb, 0xe3, 0x3c, 0x34, 0x4e, 0x02,
								0x69, 0x82, 0x46, 0x87, 0xa2, 0x63, 0xff,
								0xf0, 0x57, 0x96, 0x2b, 0x5a, 0x49, 0x72,
								0x12, 0xe4};

// Variables for checking the registry for the registry entry
// in the info key.
//...........................................................
TCHAR			szValueName[] = "Tsc.exe";
TCHAR			szRegName[] = "Registered To";
TCHAR			szRegNumber[] = "Registration Number";
TCHAR			szRegEncryptedData[] = "Encrypted Data";
TCHAR			szRegRDTSC[] = "Check For RDTSC";
TCHAR			szRBBFile[] = "Random Bits Bin File";
BOOL			bProgramRegistered = TRUE;
DWORD			dwEncryptedData;
BOOL			bP1 = TRUE;
BOOL			bSha = FALSE;
BOOL			bNewStyle;
LPBYTE			lpL = "}";

// Registry entries.
//..................
LPCTSTR			lpszMainEntry = "Software\\TAN$TAAFL Software Company\\Top Secret Crypto";
LPCTSTR			lpszCompletesRequired = "Completes Required";
LPCTSTR			lpszMarginalsRequired = "Marginals Required";
LPCTSTR			lpszRepeatWipe = "Repeat Wipe";
LPCTSTR			lpszFinalWipeChar = "Final Wipe Character";
LPCTSTR			lpszLogo = "Logo";
LPCTSTR			lpszPlaySounds = "Play Sounds";
LPCTSTR			lpszLeftAlign = "Left Align";
LPCTSTR			lpszSaveandLoad = "Save and Load Key Rings";
LPCTSTR			lpszWipeAfterUse = "Wipe OTP Key File After Use";
LPCTSTR			lpszPublicKeyRing = "Public Key Ring";
LPCTSTR			lpszSecretKeyRing = "Secret Key Ring";
LPCTSTR			lpszPackSize = "Pack Size";
LPCTSTR			lpszToolbar = "Toolbar";
LPCTSTR			lpszWhichToolbar = "Which Toolbar";
LPCTSTR			lpszLastWindowPosition = "Last Window Position";

// Initilaize the Md5 state and bit count.
//........................................
VOID Md5Initialize(LPMD5_CTX lpMd5Context)
{
	lpMd5Context->BITS[0] = 0;
	lpMd5Context->BITS[1] = 0;
	lpMd5Context->STATE[0] = 0x67452301;
	lpMd5Context->STATE[1] = 0xefcdab89;
	lpMd5Context->STATE[2] = 0x98badcfe;
	lpMd5Context->STATE[3] = 0x10325476;
}

// Update the Md5 context state to reflect the addition of
// another buffer full of data.
//........................................................
VOID Md5Update(LPMD5_CTX lpMd5Context, LPBYTE lpInBuffer, DWORD dwBufferLength)
{
	DWORD	Top;
	LPBYTE	lpMd5Buffer;
	LPBYTE	lpMd5Bits;
	LPBYTE	lpBufferIn;

	lpBufferIn = lpInBuffer;

	__asm
	{
		// Setup our pointer into the Md5Context.
		//.......................................
		mov		edi,lpMd5Context
		mov		lpMd5Buffer,edi
		mov		lpMd5Bits,edi
		add		lpMd5Buffer,(6*4)
		add		lpMd5Bits,(4*4)

		// Update the bit count in the MD5_CTX.
		//.....................................
		mov		edi,lpMd5Bits
		mov		eax,dword ptr [edi]		// Bits
		mov		Top,eax
		mov		eax,dwBufferLength
		shl		eax,3
		add		dword ptr [edi],eax		// Bits
		adc		dword ptr [edi+4],0		// Bits + 4

		// See if we have any odd chunks of data left in the
		// Md5 Buffer.
		//..................................................
		shr		Top,3
		and		Top,3fh
		cmp		Top,0
		je		L2

		// We have something left in the Md5 Buffer.
		//..........................................
		mov		edi,lpMd5Buffer
		add		edi,Top
		mov		eax,64
		sub		eax,Top
		mov		Top,eax
		cmp		dwBufferLength,eax
		jae		L1

		// What left in the buffer, plus whats in the In Buffer
		// is less than 64 bytes.
		//.....................................................
		mov		esi,lpBufferIn
		mov		ecx,dwBufferLength
		rep		movsb
		jmp		UpdateEnd

		// Whats left in the buffer, plus whats in the In Buffer
		// equals 64 bytes or more.
		//......................................................
	L1:	mov		esi,lpBufferIn
		mov		ecx,Top
		rep		movsb
	}
	// Transform the left over plus the buffer.
	//.........................................
	Md5Transform(lpMd5Context,lpMd5Buffer);

	__asm
	{
		mov		eax,Top
		add		lpBufferIn,eax
		sub		dwBufferLength,eax
	}

	L2:
	// Process the rest of the data in 64 byte chunks.
	//................................................
	while (dwBufferLength >= 64)
	{
		__asm
		{
			mov		esi,lpBufferIn
			mov		edi,lpMd5Buffer
			mov		ecx,(64/4)
			rep		movsd
		}

		Md5Transform(lpMd5Context,lpMd5Buffer);

		__asm
		{
			add		lpBufferIn,64
			sub		dwBufferLength,64
		}
	}
	// Transfer any remaining bytes to the Md5 State Buffer.
	//......................................................
	__asm
	{
		cmp		dwBufferLength,0
		je		UpdateEnd
		mov		esi,lpBufferIn
		mov		edi,lpMd5Buffer
		mov		ecx,dwBufferLength
		rep		movsb

	UpdateEnd:
	}
}

// Md5Transform is the core of the Md5 algorithm.
// Only called from within Md5Update and Md5Final.
//................................................
VOID Md5Transform(LPMD5_CTX lpMd5Context, LPBYTE lpMd5Buffer)
{
	__asm
	{
		mov		edi,lpMd5Context
		mov		eax,dword ptr [edi]
		mov		ebx,dword ptr [edi+4]
		mov		ecx,dword ptr [edi+8]
		mov		edx,dword ptr [edi+12]

		// Setup the address for the 64 bytes of new input.
		//.................................................
		mov		edi,lpMd5Buffer

		// Peform the 64 steps of the Md5 algorithm on the 64 bytes
		// of new new data. Perform the first group of 16.
		//.........................................................
		Md5Step1(eax,ebx,ecx,edx,[0],0d76aa478h,7)
		Md5Step1(edx,eax,ebx,ecx,[1*4],0e8c7b756h,12)
		Md5Step1(ecx,edx,eax,ebx,[2*4],242070dbh,17)
		Md5Step1(ebx,ecx,edx,eax,[3*4],0c1bdceeeh,22)
		Md5Step1(eax,ebx,ecx,edx,[4*4],0f57c0fafh,7)
		Md5Step1(edx,eax,ebx,ecx,[5*4],4787c62ah,12)
		Md5Step1(ecx,edx,eax,ebx,[6*4],0a8304613h,17)
		Md5Step1(ebx,ecx,edx,eax,[7*4],0fd469501h,22)
		Md5Step1(eax,ebx,ecx,edx,[8*4],698098d8h,7)
		Md5Step1(edx,eax,ebx,ecx,[9*4],8b44f7afh,12)
		Md5Step1(ecx,edx,eax,ebx,[10*4],0ffff5bb1h,17)
		Md5Step1(ebx,ecx,edx,eax,[11*4],895cd7beh,22)
		Md5Step1(eax,ebx,ecx,edx,[12*4],6b901122h,7)
		Md5Step1(edx,eax,ebx,ecx,[13*4],0fd987193h,12)
		Md5Step1(ecx,edx,eax,ebx,[14*4],0a679438eh,17)
		Md5Step1(ebx,ecx,edx,eax,[15*4],49b40821h,22)

		// Perform the second group of 16.
		//................................
		Md5Step2(eax,ebx,ecx,edx,[1*4],0f61e2562h,5)
		Md5Step2(edx,eax,ebx,ecx,[6*4],0c040b340h,9)
		Md5Step2(ecx,edx,eax,ebx,[11*4],265e5a51h,14)
		Md5Step2(ebx,ecx,edx,eax,[0*4],0e9b6c7aah,20)
		Md5Step2(eax,ebx,ecx,edx,[5*4],0d62f105dh,5)
		Md5Step2(edx,eax,ebx,ecx,[10*4],2441453h,9)
		Md5Step2(ecx,edx,eax,ebx,[15*4],0d8a1e681h,14)
		Md5Step2(ebx,ecx,edx,eax,[4*4],0e7d3fbc8h,20)
		Md5Step2(eax,ebx,ecx,edx,[9*4],21e1cde6h,5)
		Md5Step2(edx,eax,ebx,ecx,[14*4],0c33707d6h,9)
		Md5Step2(ecx,edx,eax,ebx,[3*4],0f4d50d87h,14)
		Md5Step2(ebx,ecx,edx,eax,[8*4],455a14edh,20)
		Md5Step2(eax,ebx,ecx,edx,[13*4],0a9e3e905h,5)
		Md5Step2(edx,eax,ebx,ecx,[2*4],0fcefa3f8h,9)
		Md5Step2(ecx,edx,eax,ebx,[7*4],676f02d9h,14)
		Md5Step2(ebx,ecx,edx,eax,[12*4],8d2a4c8ah,20)

		// Perform the third group of 16.
		//...............................
		Md5Step3(eax,ebx,ecx,edx,[5*4],0fffa3942h,4)
		Md5Step3(edx,eax,ebx,ecx,[8*4],8771f681h,11)
		Md5Step3(ecx,edx,eax,ebx,[11*4],6d9d6122h,16)
		Md5Step3(ebx,ecx,edx,eax,[14*4],0fde5380ch,23)
		Md5Step3(eax,ebx,ecx,edx,[1*4],0a4beea44h,4)
		Md5Step3(edx,eax,ebx,ecx,[4*4],4bdecfa9h,11)
		Md5Step3(ecx,edx,eax,ebx,[7*4],0f6bb4b60h,16)
		Md5Step3(ebx,ecx,edx,eax,[10*4],0bebfbc70h,23)
		Md5Step3(eax,ebx,ecx,edx,[13*4],289b7ec6h,4)
		Md5Step3(edx,eax,ebx,ecx,[0*4],0eaa127fah,11)
		Md5Step3(ecx,edx,eax,ebx,[3*4],0d4ef3085h,16)
		Md5Step3(ebx,ecx,edx,eax,[6*4],4881d05h,23)
		Md5Step3(eax,ebx,ecx,edx,[9*4],0d9d4d039h,4)
		Md5Step3(edx,eax,ebx,ecx,[12*4],0e6db99e5h,11)
		Md5Step3(ecx,edx,eax,ebx,[15*4],1fa27cf8h,16)
		Md5Step3(ebx,ecx,edx,eax,[2*4],0c4ac5665h,23)

		// Perform the fourth group of 16.
		//................................
		Md5Step4(eax,ebx,ecx,edx,[0*4],0f4292244h,6)
		Md5Step4(edx,eax,ebx,ecx,[7*4],432aff97h,10)
		Md5Step4(ecx,edx,eax,ebx,[14*4],0ab9423a7h,15)
		Md5Step4(ebx,ecx,edx,eax,[5*4],0fc93a039h,21)
		Md5Step4(eax,ebx,ecx,edx,[12*4],655b59c3h,6)
		Md5Step4(edx,eax,ebx,ecx,[3*4],8f0ccc92h,10)
		Md5Step4(ecx,edx,eax,ebx,[10*4],0ffeff47dh,15)
		Md5Step4(ebx,ecx,edx,eax,[1*4],85845dd1h,21)
		Md5Step4(eax,ebx,ecx,edx,[8*4],6fa87e4fh,6)
		Md5Step4(edx,eax,ebx,ecx,[15*4],0fe2ce6e0h,10)
		Md5Step4(ecx,edx,eax,ebx,[6*4],0a3014314h,15)
		Md5Step4(ebx,ecx,edx,eax,[13*4],4e0811a1h,21)
		Md5Step4(eax,ebx,ecx,edx,[4*4],0f7537e82h,6)
		Md5Step4(edx,eax,ebx,ecx,[11*4],0bd3af235h,10)
		Md5Step4(ecx,edx,eax,ebx,[2*4],2ad7d2bbh,15)
		Md5Step4(ebx,ecx,edx,eax,[9*4],0eb86d391h,21)

		// Update the Md5 State.
		//......................
		mov		edi,lpMd5Context
		add		dword ptr [edi],eax
		add		dword ptr [edi+4],ebx
		add		dword ptr [edi+8],ecx
		add		dword ptr [edi+12],edx
	}
}

// Md5Final takes care of any remaining bytes and the bit count.
//..............................................................
VOID Md5Final(LPBYTE lpDigest, LPMD5_CTX lpMd5Context)
{
	DWORD	dwCountBytes;
	LPBYTE	lpMd5Buffer;
	LPBYTE	lpMd5Bits;

	__asm
	{
		// Setup our pointer into the Md5Context.
		//.......................................
		mov		edi,lpMd5Context
		mov		lpMd5Buffer,edi
		mov		lpMd5Bits,edi
		add		lpMd5Buffer,(6*4)
		add		lpMd5Bits,(4*4)

		// Compute bytes mod 64 to see if we have an odd lot left.
		//........................................................
		mov		edi,lpMd5Bits
		mov		eax,dword ptr [edi]
		shr		eax,3
		and		eax,3fh
		mov		dwCountBytes,eax

		// Set the first character of padding to 80h.
		//...........................................
		mov		edi,lpMd5Buffer
		add		edi,eax
		mov		al,80h
		stosb

		// Bytes of padding needed to make 64 bytes.
		//..........................................
		mov		eax,(64-1)
		sub		eax,dwCountBytes
		mov		dwCountBytes,eax
		cmp		dwCountBytes,8h
		jae		L1

		// dwCountBytes is less than 8 so we need two blocks of
		// padding. Not enough room in the first block to hold
		// the 8 byte bit count.
		//.....................................................
		mov		al,0h
		mov		ecx,dwCountBytes
		rep		stosb
	}
	Md5Transform(lpMd5Context,lpMd5Buffer);

	__asm
	{
		// Now fill the next block with 56 bytes of null.
		//...............................................
		mov		edi,lpMd5Buffer
		mov		eax,0h
		mov		ecx,(56/4)
		rep		stosd
		jmp		L2

		// dwCountBytes was greater than or equal to 8.
		//.............................................
	L1:	sub		dwCountBytes,8
		mov		ecx,dwCountBytes
		mov		al,0h
		rep		stosb

		// Append the bit count to the end of the Md5 Buffer.
		//...................................................
	L2:	mov		esi,lpMd5Bits
		mov		eax,dword ptr [esi]
		stosd
		mov		eax,dword ptr [esi+4]
		stosd
	}
	// Do the final transformation.
	//.............................
	Md5Transform(lpMd5Context,lpMd5Buffer);
	CopyMemory(lpDigest,lpMd5Context,MD5_DIGEST_SIZE);
	ZeroMemory(lpMd5Context,sizeof(MD5_CTX));
}

// Calculate a Md5 message digest for a file.
//...........................................
BOOL FileMd5(LPBYTE lpMd5File, LPBYTE lpMd5ForFile, LPBYTE lpMd5Append, DWORD dwAppendLength)
{
	LPBYTE		lpMd5Buffer;
	HANDLE		hMd5;
	DWORD		dwBytesRead;
	BOOL		bResult = FALSE;

	// Allocate 128k for the buffer.
	//..............................
	lpMd5Buffer = AllocateMemory(Md5BufferSize);
	if (!lpMd5Buffer)
	{
		goto Md5End;
	}
	// Open the file.
	//...............
	hMd5 = CreateMyFile((LPTSTR)lpMd5File,GENERIC_READ,0,NULL,
		                 OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hMd5)
	{
		goto Md5End;
	}
	Md5Initialize(&Md5Context);

	// Enter a loop to process the file.
	//..................................
	while(TRUE)
	{
		bResult = ReadMyFile((LPTSTR)lpMd5File,hMd5,lpMd5Buffer,Md5BufferSize,
						      &dwBytesRead,NULL);
		if (!bResult)
		{
			goto Md5End;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		Md5Update(&Md5Context,lpMd5Buffer,dwBytesRead);
	}
	// Finish up the md5 calculations.
	//................................
	Md5Update(&Md5Context,lpMd5Append,dwAppendLength);
	Md5Final(lpMd5ForFile,&Md5Context);

	Md5End:

	if (lpMd5Buffer)
	{
		ZeroMemory(lpMd5Buffer,Md5BufferSize);
		DeallocateMemory(lpMd5Buffer);
	}
	if (hMd5)
	{
		CloseMyHandle((LPTSTR)lpMd5File,hMd5);
	}
	return(bResult);
}

// Check to see if the Tsc.exe registery key is present and set to 2082586471.
// If it is not present the program was not installed with the installation
// program.
//............................................................................
BOOL CheckTheRegistry()
{
	BOOL		bResult = FALSE;
	LONG		lResult;
	DWORD		dwKeySize = sizeof(DWORD);
	HKEY		hKey;

	lResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE,lpszMainEntry,0,KEY_QUERY_VALUE,&hKey);

	if (lResult != ERROR_SUCCESS)
	{
		goto CheckEnd;
	}
	// Check the Tsc.exe value in the registry.
	//.........................................
	lResult = RegQueryValueEx(hKey,(LPCTSTR)&szValueName,0,NULL,
							 (LPBYTE)&cfg.dwKeyValue,&dwKeySize);

	if (lResult != ERROR_SUCCESS)
	{
		goto CheckEnd;
	}
	lResult = RegCloseKey(hKey);
	if (lResult != ERROR_SUCCESS)
	{
		goto CheckEnd;
	}
	if (cfg.dwKeyValue == cfg.dwDefaultValue)
	{
		bResult = TRUE;
	}

	CheckEnd:

	return(bResult);
}

// Conduct an Md5 program check on the exe file. Used to check if
// the file has been altered. Returns FALSE for os error or invalid
// Md5 check value. 
//.................................................................
BOOL Md5ExeFileCheck(LPBYTE lpExeFile)
{
	LARGE_INTEGER	li;
	LPBYTE			lpMd5Buffer;
	DWORD			dwFrontEnd;
	DWORD			dwBytesRead;
	HANDLE			hExeFile = 0;
	BOOL			bResult;
	BOOL			bOK = FALSE;
	BYTE			IsEqual;

	// Initialize the md5 structure.
	//..............................
	Md5Initialize(&Md5Context);

	lpMd5Buffer = AllocateMemory(Md5BufferSize);
	if (!lpMd5Buffer)
	{
		goto Md5CheckEnd;
	}
	// Open the file.
	//...............
	hExeFile = CreateMyFile((LPTSTR)lpExeFile,GENERIC_READ,FILE_SHARE_READ,NULL,
							 OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);

	if (!hExeFile)
	{
		// If the operating system will not allow access to the exe file we do not
		// want to punish the user, so we let it go by.
		//........................................................................
		if (dwMyErrorCode == ERROR_ACCESS_DENIED || dwMyErrorCode == ERROR_SHARING_VIOLATION)
		{
			bOK = TRUE;
			FillMemory(&ProgramCheck,sizeof(ProgramCheck),0x24);
			goto Md5CheckEnd;
		}
	}
	// Calculate the files md5 check value and see if it is correct.
	//..............................................................
	dwFrontEnd = ProgramCheck.PROGRAM_FRONT_END;
	while(dwFrontEnd > 0)
	{
		if(dwFrontEnd > Md5BufferSize)
		{
			dwBytesRead = Md5BufferSize;
			dwFrontEnd -= Md5BufferSize;
		}
		else
		{
			dwBytesRead = dwFrontEnd;
			dwFrontEnd = 0;
		}
		bResult = ReadMyFile((LPTSTR)lpExeFile,hExeFile,lpMd5Buffer,
							  dwBytesRead,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto Md5CheckEnd;
		}
		Md5Update(&Md5Context,lpMd5Buffer,dwBytesRead);
	}
	// Skip the embedded md5 check value.
	//...................................
	li.QuadPart = 16;
	li.QuadPart = SetMyFilePointer((LPTSTR)lpExeFile,hExeFile,li.QuadPart,FILE_CURRENT);
	if (li.QuadPart == -1)
	{
		goto Md5CheckEnd;
	}
	// Finish the rest of the file.
	//.............................
	while(TRUE)
	{
		bResult = ReadMyFile((LPTSTR)lpExeFile,hExeFile,lpMd5Buffer,
							  Md5BufferSize,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto Md5CheckEnd;
		}
		if (dwBytesRead == 0)
		{
			break;
		}
		Md5Update(&Md5Context,lpMd5Buffer,dwBytesRead);
	}
	// Finalize the md5 check value.
	//..............................
	Md5Final((LPBYTE)&ProgramCheck.MD5_COMPUTATION2,&Md5Context);

	// Compare the two md5 check values.
	//..................................
	__asm
	{
		mov		esi,offset ProgramCheck.MD5_COMPUTATION1
		mov		edi,offset ProgramCheck.MD5_COMPUTATION2
		mov		ecx,16
		repe	cmpsb
		sete	IsEqual
	}

	if (IsEqual)
	{
		bOK = TRUE;
	}
	// Signal the calling program that the md5 check was done.
	//........................................................
	FillMemory(&ProgramCheck,sizeof(ProgramCheck),0x24);

	Md5CheckEnd:

	if (lpMd5Buffer)
	{
		DeallocateMemory(lpMd5Buffer);
	}
	if (hExeFile)
	{
		CloseMyHandle(lpExeFile,hExeFile);
	}
	return(bOK);
}

// Bypass check for exe file MD5 security check.
//..............................................
BOOL BPC()
{
	BYTE		IsEqual;
	BOOL		bByPass = FALSE;

	__asm
	{
		mov		al,0x24
		mov		edi,offset ProgramCheck.MD5_COMPUTATION1
		mov		ecx,16
		repe	scasb
		sete	IsEqual
	}
	if (!IsEqual)
	{
		SetLastError(IDS_MD5BYPASS);
		ErrorProcedure(lpszNA,IDS_SECURITY,MB_OK);
		bByPass = TRUE;

		// Let's exit this program.
		//.........................
		PostMessage(hMainWindow,WM_CLOSE,0,0);
	}
	return(bByPass);
}

// Get options for Top Secret Crypto.
//...................................
VOID GetOptions()
{
	int				iDlgResult;
	DWORD			dwOldHelpTopic;

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;

	// Change the help topic.
	//.......................
	dwOldHelpTopic = ChangeHelpTopic(IDH_OPTIONS);

	iDlgResult = DialogBox(hInst,TEXT("GETTHEOPTIONS"),hMainWindow,(DLGPROC)GetTheOptionsProc);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
	}

	EmptyTheMessageQue();
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for the Get the Options dialog box.
//.......................................................
LRESULT CALLBACK GetTheOptionsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	HWND		hMyBuddy5;
	HWND		hMyBuddy6;
	HWND		hMyBuddy7;
	HWND		hMyBuddy8;
	HWND		hSpinBox5;
	HWND		hSpinBox6;
	HWND		hSpinBox7;
	HWND		hSpinBox8;
	DWORD		dwStyle;
	BOOL		bError;
	UINT		uiState;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup our spinboxes.
			//.....................
			hMyBuddy5 = GetDlgItem(hDlg,IDC_BUDDY5);
			hMyBuddy6 = GetDlgItem(hDlg,IDC_BUDDY6);
			hMyBuddy7 = GetDlgItem(hDlg,IDC_BUDDY7);
			hMyBuddy8 = GetDlgItem(hDlg,IDC_BUDDY8);

			dwStyle = UDS_WRAP | UDS_ARROWKEYS | UDS_ALIGNRIGHT | UDS_SETBUDDYINT | UDS_NOTHOUSANDS;
			hSpinBox5 = CreateMySpinBox(dwStyle,0,0,8,8,hDlg,IDC_REPEAT,
										hMyBuddy5,10,1,(int)cfg.dwRepeatWipeProc);
			hSpinBox6 = CreateMySpinBox(dwStyle,0,0,8,8,hDlg,IDC_FINAL,
										hMyBuddy6,255,0,(int)cfg.dwFinalWipeCharacter);
			hSpinBox7 = CreateMySpinBox(dwStyle,0,0,8,8,hDlg,IDC_MARGINALS,
										hMyBuddy7,9,1,(int)cfg.dwMarginalsRequired);
			hSpinBox8 = CreateMySpinBox(dwStyle,0,0,8,8,hDlg,IDC_COMPLETES,
										hMyBuddy8,9,1,(int)cfg.dwCompletesRequired);

			// Set the values for the edit boxes.
			//...................................
			SetDlgItemInt(hDlg,IDC_BUDDY5,(UINT)cfg.dwRepeatWipeProc,FALSE);
			SetDlgItemInt(hDlg,IDC_BUDDY6,(UINT)cfg.dwFinalWipeCharacter,FALSE);
			SetDlgItemInt(hDlg,IDC_BUDDY7,(UINT)cfg.dwMarginalsRequired,FALSE);
			SetDlgItemInt(hDlg,IDC_BUDDY8,(UINT)cfg.dwCompletesRequired,FALSE);

			// Set the text limit for the numbers.
			//....................................
			SendDlgItemMessage(hDlg,IDC_BUDDY5,EM_SETLIMITTEXT,(WPARAM)2,0);
			SendDlgItemMessage(hDlg,IDC_BUDDY6,EM_SETLIMITTEXT,(WPARAM)3,0);
			SendDlgItemMessage(hDlg,IDC_BUDDY7,EM_SETLIMITTEXT,(WPARAM)1,0);
			SendDlgItemMessage(hDlg,IDC_BUDDY8,EM_SETLIMITTEXT,(WPARAM)1,0);

			// Set the current setting for the logo.
			//......................................
			if (cfg.dwDisplayLogo)
			{
				CheckDlgButton(hDlg,IDC_TSCLOGO,BST_CHECKED);
			}
			else
			{
				CheckDlgButton(hDlg,IDC_TSCLOGO,BST_UNCHECKED);
			}
			// Set the current setting for the sounds.
			//........................................
			if (cfg.dwPlaySounds)
			{
				CheckDlgButton(hDlg,IDC_PLAYSOUNDS,BST_CHECKED);
			}
			else
			{
				CheckDlgButton(hDlg,IDC_PLAYSOUNDS,BST_UNCHECKED);
			}
			// Set the current setting for the left alignment of the display.
			//...............................................................
			if (cfg.dwLeftAlign)
			{
				CheckDlgButton(hDlg,IDC_LEFTALIGN,BST_CHECKED);
			}
			else
			{
				CheckDlgButton(hDlg,IDC_LEFTALIGN,BST_UNCHECKED);
			}
			// Set the current setting for saving and loading the key rings.
			//..............................................................
			if (cfg.dwSaveKeyRings)
			{
				CheckDlgButton(hDlg,IDC_SAVERINGS,BST_CHECKED);
			}
			else
			{
				CheckDlgButton(hDlg,IDC_SAVERINGS,BST_UNCHECKED);
			}
			// Set the current setting for wiping OTP key files after use.
			//............................................................
			if (cfg.dwWipeAfterUse)
			{
				CheckDlgButton(hDlg,IDC_WIPEAFTERUSE,BST_CHECKED);
			}
			else
			{
				CheckDlgButton(hDlg,IDC_WIPEAFTERUSE,BST_UNCHECKED);
			}
			// Set the current setting for the RDTSC Instruction.
			//...................................................
			if (cfg.dwCheckForRDTSC)
			{
				CheckDlgButton(hDlg,IDC_RDTSC,BST_CHECKED);
			}
			else
			{
				CheckDlgButton(hDlg,IDC_RDTSC,BST_UNCHECKED);
			}
			// Set the current setting for the title in tool tips.
			//....................................................
			if (dwMajor > 5 || (dwMajor == 5 && dwMinor >= 80))
			{
				if (cfg.dwTipTitle)
				{
					CheckDlgButton(hDlg,IDC_TTIPTITLE,BST_CHECKED);
				}
				else
				{
					CheckDlgButton(hDlg,IDC_TTIPTITLE,BST_UNCHECKED);
				}
			}
			else
			{
				CheckDlgButton(hDlg,IDC_TTIPTITLE,BST_UNCHECKED);
				EnableWindow(GetDlgItem(hDlg,IDC_TTIPTITLE),FALSE);
			}
			// If we have an administrator account, set the options.
			//......................................................
			if (bAa && bRestrictionsInEffect)
			{
				if (!(cfg.V1.dwV3 & PERMIT_CHANGE_REPEAT))
				{
					EnableWindow(GetDlgItem(hDlg,IDC_BUDDY5),FALSE);
				}
				if (!(cfg.V1.dwV3 & PERMIT_CHANGE_MARGINALS))
				{
					EnableWindow(GetDlgItem(hDlg,IDC_BUDDY7),FALSE);
				}
				if (!(cfg.V1.dwV3 & PERMIT_CHANGE_COMPLETES))
				{
					EnableWindow(GetDlgItem(hDlg,IDC_BUDDY8),FALSE);
				}
				if (!(cfg.V1.dwV3 & PERMIT_AUTO_WIPE))
				{
					EnableWindow(GetDlgItem(hDlg,IDC_WIPEAFTERUSE),FALSE);
				}
			}
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));

			if (!hSpinBox5 || !hSpinBox6 || !hSpinBox7 || !hSpinBox8)
			{
				return(FALSE);
			}
			else
			{
				return(TRUE);
			}
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					// Retrieve what we have entered in the dialog box.
					//.................................................
					cfg.dwRepeatWipeProc = GetDlgItemInt(hDlg,IDC_BUDDY5,&bError,FALSE);
					cfg.dwFinalWipeCharacter = GetDlgItemInt(hDlg,IDC_BUDDY6,&bError,FALSE);
					cfg.dwMarginalsRequired = GetDlgItemInt(hDlg,IDC_BUDDY7,&bError,FALSE);
					cfg.dwCompletesRequired = GetDlgItemInt(hDlg,IDC_BUDDY8,&bError,FALSE);

					// Get the state of the title in tool tip radiobutton.
					//....................................................
					if (dwMajor > 5 || (dwMajor == 5 && dwMinor >= 80))
					{
						uiState = IsDlgButtonChecked(hDlg,IDC_TTIPTITLE);
						if (uiState)
						{
							cfg.dwTipTitle = 1;
						}
						else
						{
							cfg.dwTipTitle = 0;
						}
					}
					else
					{
						cfg.dwTipTitle = 0;
					}
					// Get the state of the logo radiobutton.
					//.......................................
					uiState = IsDlgButtonChecked(hDlg,IDC_TSCLOGO);
					if (uiState)
					{
						cfg.dwDisplayLogo = 1;
					}
					else
					{
						cfg.dwDisplayLogo = 0;
					}
					// Get the state of the sound radiobutton.
					//........................................
					uiState = IsDlgButtonChecked(hDlg,IDC_PLAYSOUNDS);
					if (uiState)
					{
						cfg.dwPlaySounds = 1;
					}
					else
					{
						cfg.dwPlaySounds = 0;
					}
					// Get the state of the left align radiobutton.
					//.............................................
					uiState = IsDlgButtonChecked(hDlg,IDC_LEFTALIGN);
					if (uiState)
					{
						cfg.dwLeftAlign = 1;
					}
					else
					{
						cfg.dwLeftAlign = 0;
					}
					// Get the state of the save key rings radiobutton.
					//.................................................
					uiState = IsDlgButtonChecked(hDlg,IDC_SAVERINGS);
					if (uiState)
					{
						cfg.dwSaveKeyRings = 1;
					}
					else
					{
						cfg.dwSaveKeyRings = 0;
					}
					// Get the state of the wipe after use radiobutton.
					//.................................................
					uiState = IsDlgButtonChecked(hDlg,IDC_WIPEAFTERUSE);
					if (uiState)
					{
						cfg.dwWipeAfterUse = 1;
					}
					else
					{
						cfg.dwWipeAfterUse = 0;
					}
					// Get the state of the RDTSC Instruction radiobutton.
					//....................................................
					uiState = IsDlgButtonChecked(hDlg,IDC_RDTSC);
					if (uiState)
					{
						cfg.dwCheckForRDTSC = 1;
					}
					else
					{
						cfg.dwCheckForRDTSC = 0;
					}
					// Check out the times to repeat government wipe.
					// Min of 1 and max of 10.
					//...............................................
					if (cfg.dwRepeatWipeProc == 0 || cfg.dwRepeatWipeProc > 10)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_REPEATWIPE,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_BUDDY5));
						break;
					}
					// Check out the final wipe character.
					//....................................
					if (cfg.dwFinalWipeCharacter > 255)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_FINALCHAR,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_BUDDY6));
						break;
					}
					// Check out the marginals required.
					//..................................
					if (cfg.dwMarginalsRequired == 0 || 
						cfg.dwMarginalsRequired > 9)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_MARGINALS,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_BUDDY7));
						break;
					}
					// Check out the completes required.
					//..................................
					if (cfg.dwCompletesRequired == 0 || 
						cfg.dwCompletesRequired > 9)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_COMPLETES,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_BUDDY8));
						break;
					}
					// If we made it this far, update the registry
					// entries.
					//............................................
					UpdateTheRegistry();
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_TSCLOGO:
				{
					uiState = IsDlgButtonChecked(hDlg,IDC_TSCLOGO);
					if (uiState == BST_CHECKED)
					{
						CheckDlgButton(hDlg,IDC_TSCLOGO,BST_UNCHECKED);
					}
					else
					{
						CheckDlgButton(hDlg,IDC_TSCLOGO,BST_CHECKED);
					}
				}
				break;

				case IDC_PLAYSOUNDS:
				{
					uiState = IsDlgButtonChecked(hDlg,IDC_PLAYSOUNDS);
					if (uiState == BST_CHECKED)
					{
						CheckDlgButton(hDlg,IDC_PLAYSOUNDS,BST_UNCHECKED);
					}
					else
					{
						CheckDlgButton(hDlg,IDC_PLAYSOUNDS,BST_CHECKED);
					}
				}
				break;

				case IDC_TTIPTITLE:
				{
					uiState = IsDlgButtonChecked(hDlg,IDC_TTIPTITLE);
					if (uiState == BST_CHECKED)
					{
						CheckDlgButton(hDlg,IDC_TTIPTITLE,BST_UNCHECKED);
										
						SendMessage(hWndTT,TTM_SETTITLE,(WPARAM)(int)0,
								   (LPARAM)lpszNullString);
					}
					else
					{
						CheckDlgButton(hDlg,IDC_TTIPTITLE,BST_CHECKED);

						SendMessage(hWndTT,TTM_SETTITLE,(WPARAM)(int)1,
								   (LPARAM)TEXT("Execute Command"));
						
					}
				}
				break;

				case IDC_LEFTALIGN:
				{
					uiState = IsDlgButtonChecked(hDlg,IDC_LEFTALIGN);
					if (uiState == BST_CHECKED)
					{
						CheckDlgButton(hDlg,IDC_LEFTALIGN,BST_UNCHECKED);
					}
					else
					{
						CheckDlgButton(hDlg,IDC_LEFTALIGN,BST_CHECKED);
					}
				}
				break;

				case IDC_SAVERINGS:
				{
					uiState = IsDlgButtonChecked(hDlg,IDC_SAVERINGS);
					if (uiState == BST_CHECKED)
					{
						CheckDlgButton(hDlg,IDC_SAVERINGS,BST_UNCHECKED);
					}
					else
					{
						CheckDlgButton(hDlg,IDC_SAVERINGS,BST_CHECKED);
					}
				}
				break;

				case IDC_WIPEAFTERUSE:
				{
					uiState = IsDlgButtonChecked(hDlg,IDC_WIPEAFTERUSE);
					if (uiState == BST_CHECKED)
					{
						CheckDlgButton(hDlg,IDC_WIPEAFTERUSE,BST_UNCHECKED);
					}
					else
					{
						CheckDlgButton(hDlg,IDC_WIPEAFTERUSE,BST_CHECKED);
					}
				}
				break;

				case IDC_RDTSC:
				{
					uiState = IsDlgButtonChecked(hDlg,IDC_RDTSC);
					if (uiState == BST_CHECKED)
					{
						CheckDlgButton(hDlg,IDC_RDTSC,BST_UNCHECKED);
					}
					else
					{
						CheckDlgButton(hDlg,IDC_RDTSC,BST_CHECKED);
					}
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Update the registry.
//.....................
VOID UpdateTheRegistry()
{
	HKEY		hKeyResult;
	DWORD		dwDisposition;
	DWORD		dwBytes;
	LONG		lResult;

	hKeyResult = 0;
	dwBytes = sizeof(DWORD);

	if (!bRemoveableMedia || dwRemoveableInstalled == REMOVEABLE_INSTALLED)
	{
		// Open the registry entry for the RDTSC instruction.
		//...................................................
		lResult = RegCreateKeyEx(HKEY_LOCAL_MACHINE,lpszMainEntry,
								 0,"",REG_OPTION_NON_VOLATILE,KEY_WRITE,
								 NULL,&hKeyResult,&dwDisposition);

		// If not successfull, tell the world.
		//....................................
		if (lResult != ERROR_SUCCESS)
		{
			SetLastError((DWORD)lResult);
			ErrorProcedure((LPTSTR)lpszMainEntry,IDS_REGISTRYCREATE,MB_OK);
			return;
		}
		lResult = RegSetValueEx(hKeyResult,(LPCTSTR)&szRegRDTSC,
								0,REG_DWORD,(BYTE *)&cfg.dwCheckForRDTSC,sizeof(DWORD));
		if (lResult != ERROR_SUCCESS)
		{
			SetLastError((DWORD)lResult);
			ErrorProcedure((LPTSTR)&szRegRDTSC,IDS_REGSETVALUE,MB_OK);
			return;
		}
		RegCloseKey(hKeyResult);

		// Now open or create the registry entries for this user.
		//.......................................................
		lResult = RegCreateKeyEx(HKEY_CURRENT_USER,lpszMainEntry,
								 0,"",REG_OPTION_NON_VOLATILE,KEY_WRITE,
								 NULL,&hKeyResult,&dwDisposition);

		// If not successfull, tell the world.
		//....................................
		if (lResult != ERROR_SUCCESS)
		{
			SetLastError((DWORD)lResult);
			ErrorProcedure((LPTSTR)lpszMainEntry,IDS_REGISTRYCREATE,MB_OK);
			return;
		}
		SetCurrentUserRegistryEntries(hKeyResult);
		RegCloseKey(hKeyResult);
	}
	// Write the cfg file data.
	//.........................
	if (bRemoveableMedia)
	{
		WriteMyCfgFile();
	}
}

// Check to see if the program is properly registered.
//....................................................
BOOL CheckRegistration()
{
	BOOL		bResult = FALSE;
	LONG		lResult;
	HKEY		hKey = 0;
	DWORD		dwKeySize;

	if (!bRemoveableMedia || bFirstTimeRead)
	{
		// Retrieve values for all users.
		//...............................
		lResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE,lpszMainEntry,0,KEY_QUERY_VALUE,&hKey);

		if (lResult != ERROR_SUCCESS)
		{
			goto CheckEnd;
		}
		// Get the RDTSC status.
		//......................
		dwKeySize = 4;
		lResult = RegQueryValueEx(hKey,(LPCTSTR)&szRegRDTSC,0,NULL,
								 (LPBYTE)&cfg.dwCheckForRDTSC,&dwKeySize);
		if (lResult != ERROR_SUCCESS)
		{
			goto CheckEnd;
		}
		// Get the registered name.
		//.........................
		dwKeySize = sizeof(cfg.Reg.Name);
		lResult = RegQueryValueEx(hKey,(LPCTSTR)&szRegName,0,NULL,(LPBYTE)&cfg.Reg.Name,
								  &dwKeySize);

		if (lResult != ERROR_SUCCESS || dwKeySize <= 1)
		{
			goto CheckEnd;
		}
		// Get the registration number.
		//.............................
		dwKeySize = sizeof(cfg.Reg.Number);
		lResult = RegQueryValueEx(hKey,(LPCTSTR)&szRegNumber,0,NULL,(LPBYTE)&cfg.Reg.Number,
								  &dwKeySize);

		if (lResult != ERROR_SUCCESS || dwKeySize < 48)
		{
			goto CheckEnd;
		}
		// See if we have a Sha registration number.
		//..........................................
		if (dwKeySize == 60)
		{
			bSha = TRUE;
		}
		// Get the encrypted data.
		//........................
		dwKeySize = sizeof(cfg.Reg.Data);
		lResult = RegQueryValueEx(hKey,(LPCTSTR)&szRegEncryptedData,0,NULL,
								 (LPBYTE)&cfg.Reg.Data,&dwKeySize);
		if (lResult != ERROR_SUCCESS || dwKeySize < 128)
		{
			goto CheckEnd;
		}
		// Get the path for the random bits bin file.
		//...........................................
		dwKeySize = (MAX_PATH+1);
		lResult = RegQueryValueEx(hKey,(LPCTSTR)&szRBBFile,0,NULL,(LPBYTE)&cfg.RandomBitsFile,
							      &dwKeySize);
		if (lResult != ERROR_SUCCESS)
		{
			goto CheckEnd;
		}
	}
	else
	{
		dwKeySize = lstrlen((LPCTSTR)&cfg.Reg.Number);
		if (dwKeySize != 47 && dwKeySize != 59)
		{
			goto CheckEnd;
		}
		if (dwKeySize == 59)
		{
			bSha = TRUE;
		}
	}
	// We have retrieved the name and number from the registry.
	// See if they check out.
	//.........................................................
	if (bSha)
	{
		bResult = CalculateRegistrationNumberSha();
	}
	else
	{
		bResult = CalculateRegistrationNumber();
	}

	CheckEnd:

	if (hKey)
	{
		RegCloseKey(hKey);
	}
	return(bResult);
}

// Display the registration reminder screen where one can
// enter the required information.
//.......................................................
BOOL RegistrationReminder()
{
	BOOL		bResult = FALSE;
	int			iResult;
	LONG		lResult;
	HKEY		hKey = 0;
	DWORD		dwOldHelpTopic;

	dwOldHelpTopic = ChangeHelpTopic(IDH_REGISTER);
	bNewStyle = TRUE;

	iResult = DialogBox(hInst,TEXT("REGISTERNEW"),hMainWindow,(DLGPROC)RegisterNewProc);

	EmptyTheMessageQue();

	if(hDlgFont)
	{
		DeleteObject(hDlgFont);
		hDlgFont = 0;
	}
	if (iResult == IDC_OLDCODES)
	{
		bNewStyle = FALSE;
		iResult = DialogBox(hInst,TEXT("REGISTER"),hMainWindow,(DLGPROC)RegisterProc);
	}
	EmptyTheMessageQue();

	if(hDlgFont)
	{
		DeleteObject(hDlgFont);
		hDlgFont = 0;
	}
	if (iResult == IDC_ENTERCODES)
	{
		if (!bRemoveableMedia || bFirstTimeRead)
		{
			// Set the registry entries for our successful registration.
			//..........................................................
			lResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE,lpszMainEntry,0,KEY_WRITE,&hKey);

			if (lResult != ERROR_SUCCESS)
			{
				SetLastError((DWORD)lResult);
				ErrorProcedure((LPTSTR)lpszMainEntry,IDS_REGOPENKEY,MB_OK);	
				goto RREnd;
			}
			lResult = RegSetValueEx(hKey,(LPCTSTR)&szRegName,0,REG_SZ,(BYTE *)&cfg.Reg.Name,
									lstrlen((LPCTSTR)&cfg.Reg.Name) + 1);
			if (lResult != ERROR_SUCCESS)
			{
				SetLastError((DWORD)lResult);
				ErrorProcedure((LPTSTR)&szRegName,IDS_REGSETVALUE,MB_OK);
				goto RREnd;
			}
			lResult = RegSetValueEx(hKey,(LPCTSTR)&szRegNumber,0,REG_SZ,(BYTE *)&cfg.Reg.Number,
								    lstrlen((LPCTSTR)&cfg.Reg.Number) + 1);
			if (lResult != ERROR_SUCCESS)
			{
				SetLastError((DWORD)lResult);
				ErrorProcedure((LPTSTR)&szRegNumber,IDS_REGSETVALUE,MB_OK);
				goto RREnd;
			}
			lResult = RegSetValueEx(hKey,(LPCTSTR)&szRegEncryptedData,0,REG_BINARY,
								   (BYTE *)cfg.Reg.Data,dwEncryptedData);
			if (lResult != ERROR_SUCCESS)
			{
				SetLastError((DWORD)lResult);
				ErrorProcedure((LPTSTR)&szRegEncryptedData,IDS_REGSETVALUE,MB_OK);
				goto RREnd;
			}
		}
		bResult = TRUE;

		RREnd:
		if (hKey)
		{
			RegCloseKey(hKey);
		}
	}
	else if (iResult == IDC_MYEXIT)
	{
		bExitTheProgram = TRUE;
	}
	ChangeHelpTopic(dwOldHelpTopic);

	return(bResult);
}

// CALLBACK procedure for entering registration information.
//..........................................................
LRESULT CALLBACK RegisterProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	BOOL		bResult;
	int			iCount;
	HANDLE		hFile;
	DWORD		dwBytesRead;
	DWORD		dwOldHelpTopic;
	DWORD		dwUsesLeft = 0;
	TCHAR		szBuffer[512];
	BOOL		bEvalFocus = TRUE;

	switch(uiMsg)
	{
		case (WM_INITDIALOG):
		{
			ZeroMemory(&cfg.Reg,sizeof(REGISTRATION));
			ZeroMemory(&szDestination,MAX_PATH);

			// Setup the text limits for the name and number.
			//...............................................
			SendDlgItemMessage(hDlg,IDC_REGNAME1,EM_SETLIMITTEXT,(WPARAM)100,0);
			SendDlgItemMessage(hDlg,IDC_REGNUMBER1,EM_SETLIMITTEXT,(WPARAM)100,0);
			SendDlgItemMessage(hDlg,IDC_OPEN_ENCR1,EM_SETLIMITTEXT,(WPARAM)MAX_PATH,0);

			SetBoldFont(hDlg,IDC_NEWBIE_HELP,0);
			LoadString(hInst,IDS_NEWBIE,(LPTSTR)&szBuffer,sizeof(szBuffer));
			SetDlgItemText(hDlg,IDC_NEWBIE_HELP,(LPCTSTR)&szBuffer);

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));

			if (bEvalFocus)
			{
				SetFocus(GetDlgItem(hDlg,IDC_EVAL));
			}
			else
			{ 
				SetFocus(GetDlgItem(hDlg,IDC_ENTERCODES));
			}
			return(FALSE);
		}

		case (WM_COMMAND):
		{
			switch (LOWORD(wParam))
			{
				case IDC_ENTERCODES:
				{
					GetDlgItemText(hDlg,IDC_REGNAME1,cfg.Reg.Name,sizeof(cfg.Reg.Name)-5);
					GetDlgItemText(hDlg,IDC_REGNUMBER1,cfg.Reg.Number,sizeof(cfg.Reg.Number));
					if (lstrlen((LPCTSTR)&szDestination) == 0)
					{
						GetDlgItemText(hDlg,IDC_OPEN_ENCR1,(LPTSTR)&szDestination,MAX_PATH);
					}
					// We cannot have blank strings.
					//..............................
					if (lstrlen((LPCTSTR)&cfg.Reg.Name) == 0)
					{
						SetFocus(GetDlgItem(hDlg,IDC_REGNAME1));
						break;
					}
					// Make sure we have a proper registration number.
					//................................................
					iCount = lstrlen((LPCTSTR)&cfg.Reg.Number);
					if (iCount != 47)
					{
						if (iCount != 59)
						{
							MessageBoxProc(hDlg,IDS_ADVISORY,IDS_INVALIDREGNUM,
										   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
							SetFocus(GetDlgItem(hDlg,IDC_REGNUMBER1));
							break;
						}
					}
					// Make sure we have something for the file name.
					//...............................................
					if (lstrlen((LPCTSTR)&szDestination) == 0)
					{
						SetFocus(GetDlgItem(hDlg,IDC_BROWSE));
						break;
					}
					// Open the file and read the encrypted data.
					//...........................................
					hFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ,0,NULL,
										  OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
					if (!hFile)
					{
						SetFocus(GetDlgItem(hDlg,IDC_BROWSE));
						break;
					}
					// Read in the data. It should never be greater than 128 bytes.
					//.............................................................
					bResult = ReadMyFile((LPTSTR)&szDestination,hFile,&cfg.Reg.Data,132,
									      &dwBytesRead,NULL);

					if (!bResult || dwBytesRead > 128)
					{
						SetFocus(GetDlgItem(hDlg,IDC_BROWSE));
						break;
					}
					bResult = CloseMyHandle((LPTSTR)&szDestination,hFile);

					dwEncryptedData = dwBytesRead;

					if (iCount == 47)
					{
						bResult = CalculateRegistrationNumber();
					}
					else if (iCount == 59)
					{
						bResult = CalculateRegistrationNumberSha();
					}
					if (!bResult)
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_REGFAILED,
									   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
						SetFocus(GetDlgItem(hDlg,IDC_REGNAME1));
						break;
					}
					EndDialog(hDlg,IDC_ENTERCODES);
				}
				break;

				case IDC_BROWSE:
				{
					bResult = GetTheEncryptedData();
					if (bResult)
					{
						SetDlgItemText(hDlg,IDC_OPEN_ENCR1,(LPCTSTR)&szDestination);
					}
					else
					{
						SetDlgItemText(hDlg,IDC_OPEN_ENCR1,lpszNullString);
					}
				}
				break;

				case IDC_EVAL:
				{
					EndDialog(hDlg,IDC_EVAL);
				}
				break;

				case IDCANCEL:
				case IDC_MYEXIT:
				{
					EndDialog(hDlg,IDC_MYEXIT);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;

				case IDC_REGISTER1:
				{
					ShellExecute(NULL,"open","http://www.topsecretcrypto.com/Purchase.htm?L4",
							     NULL,NULL,SW_SHOWNORMAL);
				}
				break;

				case IDC_REGISTER2:
				{
					dwOldHelpTopic = ChangeHelpTopic(IDH_REGISTERMAIL);
					DisplayMyHelp(hDlg);
					ChangeHelpTopic(dwOldHelpTopic);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for entering registration information. New Procedure.
//.........................................................................
LRESULT CALLBACK RegisterNewProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	BOOL		bResult;
	HANDLE		hFile;
	DWORD		dwBytesRead;
	DWORD		dwOldHelpTopic;
	DWORD		dwUsesLeft = 0;
	TCHAR		szBuffer[512];
	BOOL		bEvalFocus = TRUE;

	switch(uiMsg)
	{
		case (WM_INITDIALOG):
		{
			ZeroMemory(&cfg.Reg,sizeof(REGISTRATION));
			ZeroMemory(&szDestination,MAX_PATH);

			SetBoldFont(hDlg,IDC_DISCOUNT,IDC_NEWBIE_HELP);

			// Setup the text limits for the file name.
			//.........................................
			SendDlgItemMessage(hDlg,IDC_OPEN_ENCR1,EM_SETLIMITTEXT,(WPARAM)MAX_PATH,0);

			LoadString(hInst,IDS_NEWBIE,(LPTSTR)&szBuffer,sizeof(szBuffer));
			SetDlgItemText(hDlg,IDC_NEWBIE_HELP,(LPCTSTR)&szBuffer);

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));

			if (bEvalFocus)
			{
				SetFocus(GetDlgItem(hDlg,IDC_EVAL));
			}
			else
			{ 
				SetFocus(GetDlgItem(hDlg,IDC_ENTERCODES));
			}
			return(FALSE);
		}

		case (WM_COMMAND):
		{
			switch (LOWORD(wParam))
			{
				case IDC_ENTERCODES:
				{
					if (lstrlen((LPCTSTR)&szDestination) == 0)
					{
						GetDlgItemText(hDlg,IDC_OPEN_ENCR1,(LPTSTR)&szDestination,MAX_PATH);
					}
					// Make sure we have something for the file name.
					//...............................................
					if (lstrlen((LPCTSTR)&szDestination) == 0)
					{
						SetFocus(GetDlgItem(hDlg,IDC_OPEN_ENCR1));
						break;
					}
					// Open the file and read the registration data.
					//..............................................
					hFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ,0,NULL,
										  OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
					if (!hFile)
					{
						SetFocus(GetDlgItem(hDlg,IDC_BROWSE));
						break;
					}
					// Read in the data. It should never be greater than 128 bytes.
					//.............................................................
					bResult = ReadMyFile((LPTSTR)&szDestination,hFile,&cfg.Reg,
										  sizeof(REGISTRATION),&dwBytesRead,NULL);

					if (!bResult || dwBytesRead != sizeof(REGISTRATION))
					{
						SetFocus(GetDlgItem(hDlg,IDC_BROWSE));
						break;
					}
					bResult = CloseMyHandle((LPTSTR)&szDestination,hFile);

					dwEncryptedData = sizeof(cfg.Reg.Data);
					bResult = CalculateRegistrationNumberSha();

					if (!bResult)
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_REGFAILED,
									   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
						SetFocus(GetDlgItem(hDlg,IDC_REGNAME1));
						break;
					}
					EndDialog(hDlg,IDC_ENTERCODES);
				}
				break;

				case IDC_BROWSE:
				{
					bResult = GetTheEncryptedData();
					if (bResult)
					{
						SetDlgItemText(hDlg,IDC_OPEN_ENCR1,(LPCTSTR)&szDestination);
					}
					else
					{
						SetDlgItemText(hDlg,IDC_OPEN_ENCR1,lpszNullString);
					}
				}
				break;

				case IDC_EVAL:
				{
					EndDialog(hDlg,IDC_EVAL);
				}
				break;

				case IDC_OLDCODES:
				{
					EndDialog(hDlg,IDC_OLDCODES);
				}
				break;

				case IDCANCEL:
				case IDC_MYEXIT:
				{
					EndDialog(hDlg,IDC_MYEXIT);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;

				case IDC_REGISTER1:
				{
					ShellExecute(NULL,"open","http://www.topsecretcrypto.com/Purchase.htm?L4",
							     NULL,NULL,SW_SHOWNORMAL);
				}
				break;

				case IDC_REGISTER2:
				{
					dwOldHelpTopic = ChangeHelpTopic(IDH_REGISTERMAIL);
					DisplayMyHelp(hDlg);
					ChangeHelpTopic(dwOldHelpTopic);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Calculate what the correct registration number should be.
// Returns true is there is a match.
//..........................................................
BOOL CalculateRegistrationNumber()
{
	BOOL			bResult = FALSE;
	BOOL			bError;
	int				iResult;
	LPBYTE			lpReturnAddress;
	DWORD			dwFingerPrintValue;
	TCHAR			szCheckNumber[100];
	TCHAR			szMd5Return[16];
	LPBYTE			lpMd5Return = szMd5Return;

	// Decrypt the registration value from the registry.
	//..................................................
	ClearAllVariables();
	E_Temp[0] = 0x11;
	CopyMemory(&Temp2,&cfg.Reg.Data,128);
	CopyMemory(&Modulus_N,&MemoryModN,128);
	dwN_Bytes = 128;
	bError = RsaPubDec((LPBYTE)&Temp1,(LPBYTE)&Temp2,(LPBYTE)&E_Temp,
				       (LPBYTE)&Modulus_N,dwN_Bytes);
	if (bError)
	{
		goto CalcEnd;
	}
	if (dwCountBytes != 96)
	{
		goto CalcEnd;
	}
	FillMemory(&szCheckNumber,sizeof(szCheckNumber),0x20);

	Md5Initialize(&Md5Context);
	Md5Update(&Md5Context,(LPBYTE)&TestEncrypt,lstrlen((LPCTSTR)&TestEncrypt));
	Md5Update(&Md5Context,(LPBYTE)&cfg.Reg.Name,lstrlen((LPCTSTR)&cfg.Reg.Name));
	Md5Update(&Md5Context,(LPBYTE)&Temp1,96);
	ClearAllVariables();
	Md5Update(&Md5Context,(LPBYTE)lpContextCalc,lstrlen((LPCTSTR)lpContextCalc));
	Md5Final((LPBYTE)&szMd5Return,&Md5Context);

	// Convert the md5 value to a string.
	//...................................
	__asm
	{
		mov		esi,lpMd5Return
		mov		eax,dword ptr [esi]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,(LPBYTE)&szCheckNumber);

	__asm
	{
		mov		esi,lpMd5Return
		mov		eax,dword ptr [esi+4]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	__asm
	{
		mov		esi,lpMd5Return
		mov		eax,dword ptr [esi+8]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	__asm
	{
		mov		esi,lpMd5Return
		mov		eax,dword ptr [esi+12]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	lpReturnAddress--;

	*lpReturnAddress = 0;

	// Compare the two strings.
	//.........................
	iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.Reg.Number,-1,
						   (LPCTSTR)&szCheckNumber,-1);

	bP1 = FALSE;

	if (iResult == CSTR_EQUAL)
	{
		bResult = TRUE;
	}

  CalcEnd:

	return(bResult);
}

// Calculate what the correct registration number should be.
// Returns true is there is a match.
//..........................................................
BOOL CalculateRegistrationNumberSha()
{
	BOOL			bResult = FALSE;
	BOOL			bError;
	int				iResult;
	LPBYTE			lpReturnAddress;
	DWORD			dwFingerPrintValue;
	TCHAR			szCheckNumber[100];
	TCHAR			szShaReturn[20];
	LPBYTE			lpShaReturn = szShaReturn;
	BYTE			FirstBit;
	BYTE			SecondBit;

	// Decrypt the registration value from the registry.
	//..................................................
	ClearAllVariables();
	E_Temp[0] = 0x11;
	CopyMemory(&Temp2,&cfg.Reg.Data,128);
	CopyMemory(&Modulus_N,&MemoryModN,128);
	dwN_Bytes = 128;
	bError = RsaPubDec((LPBYTE)&Temp1,(LPBYTE)&Temp2,(LPBYTE)&E_Temp,
					   (LPBYTE)&Modulus_N,dwN_Bytes);
	if (bError)
	{
		goto CalcEnd;
	}
	if (dwCountBytes != 96)
	{
		goto CalcEnd;
	}
	// A regular license has byte 19 bit 3 set to 0 and byte 86 bit 7 set to 1.
	// An umlimited site license has byte 19 bit 3 set to 1 and byte 86 bit 7 set to 0.
	//.................................................................................
	__asm
	{
		mov		esi,offset Temp1
		bt		dword ptr [esi+19],3
		setc	FirstBit
		bt		dword ptr [esi+86],7
		setnc	SecondBit
	}
	FillMemory(&szCheckNumber,sizeof(szCheckNumber),0x20);

	ShaInit(&ShaContext);
	ShaUpdate(&ShaContext,(LPBYTE)&TestEncrypt,lstrlen((LPCTSTR)&TestEncrypt));
	ShaUpdate(&ShaContext,(LPBYTE)&cfg.Reg.Name,lstrlen((LPCTSTR)&cfg.Reg.Name));
	ShaUpdate(&ShaContext,(LPBYTE)&Temp1,96);
	ShaUpdate(&ShaContext,(LPBYTE)lpContextCalc,lstrlen((LPCTSTR)lpContextCalc));
	ShaFinal((LPBYTE)&szShaReturn,&ShaContext);

	// Convert the sha value to a string.
	//...................................
	__asm
	{
		mov		esi,lpShaReturn
		mov		eax,dword ptr [esi]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,(LPBYTE)&szCheckNumber);

	__asm
	{
		mov		esi,lpShaReturn
		mov		eax,dword ptr [esi+4]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	__asm
	{
		mov		esi,lpShaReturn
		mov		eax,dword ptr [esi+8]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	__asm
	{
		mov		esi,lpShaReturn
		mov		eax,dword ptr [esi+12]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	__asm
	{
		mov		esi,lpShaReturn
		mov		eax,dword ptr [esi+16]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	lpReturnAddress--;

	*lpReturnAddress = 0;

	// Compare the two strings.
	//.........................
	iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.Reg.Number,-1,
						   (LPCTSTR)&szCheckNumber,-1);

	bP1 = FALSE;

	if (iResult == CSTR_EQUAL)
	{
		bResult = TRUE;
		bSha = TRUE;
	}

  CalcEnd:

	ClearAllVariables();

	return(bResult);
}

// Get the encrypted registration data.
//.....................................
BOOL GetTheEncryptedData()
{
	BOOL			bResult = FALSE;
	OPENFILENAME	ofn;

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szDestination;
	ofn.nMaxFile = sizeof(szDestination);
	ofn.hwndOwner = hMainWindow;
	if (bNewStyle)
	{
		ofn.lpstrFilter = TEXT("Binary File [.bin]\0*.bin\0All Files [*.*]\0*.*\0");
		ofn.lpstrTitle = TEXT("Open Binary Registration File");
	}
	else
	{
		ofn.lpstrFilter = TEXT("Binary or Text File [.bin;.txt]\0*.bin;*.txt\0All Files [*.*]\0*.*\0");
		ofn.lpstrTitle = TEXT("Open Encrypted Binary or Text Registration File");
	}
	ofn.nFilterIndex = 1;
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY |
				 OFN_SHOWHELP);
	ofn.lpstrDefExt = NULL;
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	ZeroMemory(&szDestination,sizeof(szDestination));

	if (!GetOpenFileName(&ofn))
	{
		CommDlgBoxErrorProc(IDS_GET_FILES);
		goto GetEncryptedEnd;
	}
	EmptyTheMessageQue();

	bResult = TRUE;

  GetEncryptedEnd:

	return(bResult);
}

// Move the ransdom bits bin file.
//................................
VOID MoveTheRBBFile()
{
	ULARGE_INTEGER		uliFreeCallerBytes;
	ULARGE_INTEGER		uliTotalBytes;
	int					iResult;
	BOOL				bResult;
	BOOL				bError = TRUE;
	UINT				uiDriveType;
	LONG				lResult;
	HRESULT				hr = ERROR_SUCCESS;
	HKEY				hKey;
	TCHAR				szRoot[16];
	BROWSEINFO			bi;
    LPITEMIDLIST		lpidl;
    LPMALLOC			lpMalloc;
	TCHAR				szRandomFile[MAX_PATH +1];
	TCHAR				szOutBuffer[512];
	TCHAR				szFormatBuffer[128];

	// Browse for a directory to copy the files into.
	//...............................................
	while(TRUE)
	{
		SetCurrentDirectory((LPCTSTR)&szPreviousDestinationDir);
		ZeroMemory(&szRandomFile,sizeof(szRandomFile));

		if (SUCCEEDED(SHGetMalloc(&lpMalloc))) 
		{
			ZeroMemory(&bi,sizeof(bi));
			bi.hwndOwner = hMainWindow;
			bi.pszDisplayName = 0;
			bi.lpszTitle = TEXT("Select a New Folder to move the Random Bits Bin File to.");
			bi.pidlRoot = 0;
			bi.ulFlags = BIF_RETURNONLYFSDIRS;

			// If we can use the new style of the dialog box, do it.
			//......................................................
			if (bUseNew)
			{
				hr = CoInitialize(NULL);
				if (SUCCEEDED(hr))
				{
					bi.ulFlags |= BIF_NEWDIALOGSTYLE;
				}
			}
			bi.lpfn = BrowseCallbackProc;

			lpidl = SHBrowseForFolder(&bi);

			if (bUseNew && SUCCEEDED(hr))
			{
				CoUninitialize();
			}
			if (lpidl) 
			{
				bResult = SHGetPathFromIDList(lpidl,szRandomFile);
				lpMalloc->lpVtbl->Free(lpMalloc,lpidl);
				lpMalloc->lpVtbl->Release(lpMalloc);
			}
			else
			{
				// We cancelled out.
				//..................
				goto MoveEnd;
			}
			// Save the dir name.
			//...................
			SaveDirName((LPBYTE)&szRandomFile,SAVE_DESTINATION,FALSE);

			// Setup the complete file name and check to see if it is the same.
			//.................................................................
			PathAddBackslash((LPTSTR)&szRandomFile);
			StringCbCatEx(szRandomFile,sizeof(szRandomFile),TEXT("RandomBitsBin.rbb"),
						  NULL,NULL,dwStringSafeFlag);
			iResult = CompareString(LOCALE_USER_DEFAULT,0,szRandomFile,-1,cfg.RandomBitsFile,-1);
			if (iResult == CSTR_EQUAL)
			{
				MessageBoxProc(hMainWindow,IDS_INPUT_ERROR,IDS_NOCOPYTOSAME,
							   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
				continue;
			}
			// See if we have any free disk space. cd rom drives that
			// are not writable will report zero.
			//.......................................................
			ZeroMemory(&szRoot,sizeof(szRoot));
			CopyMemory(&szRoot,&szRandomFile,3);
			bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
										(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
										(PULARGE_INTEGER)&uliTotalBytes.QuadPart,NULL);
			if (!bResult)
			{
				ErrorProcedure((LPTSTR)&szRandomFile,IDS_GETFREEDSKSPACE,MB_OK);
				return;
			}
			if (uliFreeCallerBytes.QuadPart == 0)
			{
				SetLastError(IDS_NOSPACE);
				ErrorProcedure((LPTSTR)&szRandomFile,IDS_GETFREEDSKSPACE,MB_OK);
				continue;
			}
			// Make sure we do not backup to a ram disk.
			//..........................................
			uiDriveType = GetDriveType((LPCTSTR)&szRoot);
			if (uiDriveType == DRIVE_RAMDISK)
			{
				SetLastError(IDS_RAMDRIVE);
				ErrorProcedure((LPTSTR)&szRandomFile,IDS_GETDRIVETYPE,MB_OK);
				continue;
			}
			// If we go this far with no error, we have a valid
			// destination.
			//.................................................
			break;
		}
		else
		{
			MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SELECTDIR,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
			goto MoveEnd;
		}
	}
	// We have a good destination. Copy the file.
	//...........................................
	bResult = CopyFile((LPCTSTR)&cfg.RandomBitsFile,(LPCTSTR)&szRandomFile,FALSE);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&szRandomFile,IDS_COPYFILE,MB_OK);
		goto MoveEnd;
	}
	// We copied the file OK. Set the new registry entry.
	// Set the registry entries for our successful registration.
	//..........................................................
	lResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE,lpszMainEntry,0,KEY_WRITE,&hKey);

	if (lResult != ERROR_SUCCESS)
	{
		SetLastError((DWORD)lResult);
		ErrorProcedure((LPTSTR)lpszMainEntry,IDS_REGOPENKEY,MB_OK);
		hKey = 0;
		goto MoveEnd;
	}
	// Remove the file name for the registry entry.
	//.............................................
	PathRemoveFileSpec((LPTSTR)&szRandomFile);
	lResult = RegSetValueEx(hKey,(LPCTSTR)&szRBBFile,0,REG_SZ,(BYTE *)&szRandomFile,
						    lstrlen((LPCTSTR)&szRandomFile) + 1);
	if (lResult != ERROR_SUCCESS)
	{
		SetLastError((DWORD)lResult);
		ErrorProcedure((LPTSTR)&szRBBFile,IDS_REGSETVALUE,MB_OK);
		goto MoveEnd;
	}
	bError = FALSE;

	// Restore the backslash and file name.
	//.....................................
	PathAddBackslash((LPTSTR)&szRandomFile);
	StringCbCatEx(szRandomFile,sizeof(szRandomFile),TEXT("RandomBitsBin.rbb"),NULL,NULL,
				  dwStringSafeFlag);

	// Wipe the original file.
	//........................
	WipeMyFile((LPBYTE)&cfg.RandomBitsFile,FALSE);

	CopyMemory(&cfg.RandomBitsFile,&szRandomFile,(MAX_PATH+1));

	MoveEnd:

	if (hKey)
	{
		RegCloseKey(hKey);
	}
	if (!bError)
	{
		LoadString(hInst,IDS_RBBMOVEDOK,(LPTSTR)&szFormatBuffer,sizeof(szFormatBuffer));
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFormatBuffer,
						&cfg.RandomBitsFile);
	
		MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szOutBuffer,
					   MB_ICONEXCLAMATION | MB_OK,MB_ICONEXCLAMATION,0);
	}
}
